﻿uses
  Common, DataEntry, DataStorage, RegEx, SysUtils;

//==============================================================================
// Make sure the column exists
//==============================================================================
procedure OnStartFilter(aDataStore: TDataStore; Var DoContinue: boolean; Var OutObj : TObject);
var
  DataStore: TDataStore;
  Column: TDataStoreField;
begin
  DoContinue := True;
  Column := nil;
  DataStore := GetDataStore(DATASTORE_FILESYSTEM);
  if DataStore = nil then
    Exit;
  try
    Column := DataStore.DataFields.FieldByName('Graphic Classification'); //noslz
    OutObj := Column;
    if Column = nil then
      DoContinue := False;
  finally
    DataStore.free;
  end;
end;

//==============================================================================
// Filter the files
//==============================================================================
function FilterEntry(anEntry : TEntry; InObj : TObject): integer;
var
  colResult_str: string;
  Column: TDataStoreField;
begin
  Result := -1; // Exclude
  if assigned(anEntry) then
  begin
    Column := TDataStoreField(InObj);
    if assigned(Column) then
    begin
      colResult_str := Column.AsString[anEntry];
      if colResult_str <> '' then
      begin
        if RegexMatch(colResult_str, 'Credit', True) then
          Result := 1; // Include
      end;
    end;
  end;
end;

begin
end.
